/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader;

import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.StaticTask;
import java.util.HashMap;

public final class ProgressHandler {
    public static Task TASK = new StaticTask("Idle", 0.0f);
    private String currentTask;
    private long lastUpdate = System.currentTimeMillis();
    private double currentProgress = 0.0;
    private HashMap<String, String> translations = new HashMap();

    public void setTranslations(HashMap<String, String> translations) {
        this.translations = translations;
    }

    private void tickProgress() {
        double actualProgress = TASK.getProgress();
        double divisionSpeed = actualProgress < this.currentProgress ? 3.0 : (double)DashLoader.DL.config.config.progressBarSpeedDivision;
        this.currentProgress += (actualProgress - this.currentProgress) / divisionSpeed;
    }

    public double getProgress() {
        long currentTime = System.currentTimeMillis();
        while (currentTime > this.lastUpdate) {
            this.tickProgress();
            this.lastUpdate += 10L;
        }
        return this.currentProgress;
    }

    public String getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(String currentTask) {
        this.currentTask = this.translations.getOrDefault(currentTask, currentTask);
    }
}

